

library(foreign)

getwd()
wdpfad <- "V:\\4 Intern\\7 Datenanalyse\\4 Reprsentativstudie\\2 Enddaten SAS\\2 Analysen mit R"
setwd(wdpfad) 
getwd()


#include predefined R-indicator-functions (s. Info auf risq-project.eu)
source ("RISQ-R-indicators-v21.r")


# include Sample Data (aktualisiert mit finalen TNS-Gewichten)
sampleData <-  read.table("rep_kodo_excl_suf.txt",na.strings=".") #ds erstellt in syntax rep_master_job.sas

names(sampleData)<-c("designgroup","heim","desgew","bik","aapor_rr1","aapor_e","aapor_coop1","aapor_ref1","aapor_con1",
                     "aapor_rr1_excl", "aapor_rr1_xkog","aapor_rr1_xheim","aapor_rr1_xpx")


#berblick ber die Merkmale, hinsichtlich derer Reprsentativitt (Vergleichbarkeit Resp/NonResp) abgeschtzt werden soll
head(sampleData)
summary(sampleData)


#Mit der vordefinierten Funktion RIndicator betrachtete Merkmale mssen als Faktoren angelegt sein
sampleData$designgroup<-as.factor(sampleData$designgroup)
sampleData$heim<-as.factor(sampleData$heim)
sampleData$bik<-as.factor(sampleData$bik)

sampleData$aapor_rr1<-as.factor(sampleData$aapor_rr1)

sampleData$aapor_rr1_excl<-as.factor(sampleData$aapor_rr1_excl)
sampleData$aapor_rr1_xkog<-as.factor(sampleData$aapor_rr1_xkog)
sampleData$aapor_rr1_xheim<-as.factor(sampleData$aapor_rr1_xheim)
sampleData$aapor_rr1_xpx<-as.factor(sampleData$aapor_rr1_xpx)


summary(sampleData)


analdat <-sampleData[!is.na(sampleData$aapor_rr1_excl),] #27 TN sind non-eligible und haben NA fr rr1

summary(analdat)


# R-Indikator fr finalen Datensatz KODO der Reprsentativbefragung (8013 egible Personen der Einsatzstichprobe)


# Modell A: Designmerkmale der Studie als Prdiktor v. Non-response; Analyse MIT Designgewichtung  (desgew) der Einsatzstichprobe

respModfin <- formula(aapor_rr1 ~ bik + designgroup + heim) 
#respModfin <- formula(aapor_rr1_excl ~ bik + designgroup + heim) #rerun analysis with different RRs for excluded participants

indicatfin <- getRIndicator(respModfin, analdat, analdat$desgew, family='binomial')# analdat$strata,


#Notiz: family=quasibinomial wre vielleicht besser, aber ist nicht implementiert

#names(indicatfin)
#str(indicatfin)

#interessierende Parameter ausgeben (bias-adjusted)
c(indicatfin$propMean,
  indicatfin$R, indicatfin$RSE, indicatfin$partialR,
  indicatfin$CV, indicatfin$CVSE, indicatfin$partialCV)

#Konfidenzintervalle berechnen
CICrit95 <-qnorm(p=0.975,mean=0, sd=1)
CICrit90 <-qnorm(p=0.950,mean=0, sd=1)

CI90Rfin <-c(indicatfin$R-CICrit90*indicatfin$RSE, indicatfin$R, indicatfin$R+CICrit90*indicatfin$RSE)
CI90CVfin <-c(indicatfin$CV-CICrit90*indicatfin$CVSE,indicatfin$CV, indicatfin$CV+CICrit90*indicatfin$CVSE)

CI95Rfin <-c(indicatfin$R-CICrit95*indicatfin$RSE, indicatfin$R, indicatfin$R+CICrit95*indicatfin$RSE)
CI95CVfin <-c(indicatfin$CV-CICrit95*indicatfin$CVSE,indicatfin$CV, indicatfin$CV+CICrit95*indicatfin$CVSE)


